<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Token_connection extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->database();

        // 🔥 Aquí cargamos el modelo correctamente
        $this->load->model('admin/Token_connection_model', 'tokenModel');
    }

    /**
     * Método para probar la conexión y guardar token
     */
    public function conectar($conexion_id = null) {
        if (!$conexion_id) {
            echo json_encode([
                'status' => 'error',
                'message' => 'ID de conexión inválido'
            ]);
            return;
        }

        // 🚀 Simulamos que recibimos token del certificador
        $token      = md5(uniqid(rand(), true));
        $expiracion = date('Y-m-d H:i:s', strtotime('+2 days'));
        $usuario    = 'admin'; // O el que tengas logueado

        // Guardar en DB
        $ok = $this->tokenModel->guardar_token($conexion_id, $usuario, $token, $expiracion);

        if ($ok) {
            echo json_encode([
                'status'  => 'success',
                'message' => 'Conectado con éxito al certificador.',
                'token'   => $token,
                'expira'  => $expiracion
            ]);
        } else {
            echo json_encode([
                'status'  => 'error',
                'message' => 'No se pudo guardar el token'
            ]);
        }
    }
}
